#version 130
#extension GL_EXT_gpu_shader4 : enable
// [LLCS] #1Mod01.fsh  by   XT95
 
//https://www.shadertoy.com/view/MlSXWV
// Licence CC0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iTime u_Elapsed*0.314159  //*0.1666
#define iResolution u_WindowSize

//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D iChannel0;
uniform sampler2D iChannel1;
uniform sampler2D iChannel2;
uniform sampler2D iChannel3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract

#define t (iTime*.25+10.)

float hash(float n) { return fract(sin(n) * 1e4); }
float rand(vec2 n) { 
    return fract(sin(dot(n, vec2(12.9898, 4.1414))) * 43758.5453);
}

const int nbMeta = 30;
vec3 meta[nbMeta];
float map( in vec2 p)
{
    float d = 0.;
    for(int i=0; i<nbMeta; i++)
    {
        d += meta[i].z / ( length(p-meta[i].xy));
    } 
	return d;
}

vec3 normal( in vec2 p )
{
 	vec2 eps = vec2(0.1, 0.);
    vec3 n;
    n.x = map(p) - map(p+eps.xy);
    n.y = eps.x*2.;
    n.z = map(p) - map(p+eps.yx);
    
    n = normalize(n);
    return n;
}


vec3 bckground( in vec2 uv)
{
    vec3 c = texture(iChannel0, vec2(uv.y/uv.x,t*.2+uv.y*.05)).rgb;
 	return pow( c, vec3(2.2)) + pow( c*1.3, vec3(10.2));  
}

vec3 bckground2( in vec2 uv)
{
    vec3 c = texture(iChannel1, vec2(uv.y/uv.x,t*.2+uv.y*.05)).rgb;
 	return pow( c, vec3(2.2)) + pow( c*1.3, vec3(10.2));  
}

//void mainImage( out vec4 fragColor, in vec2 fragCoord )
vec4 mainImage( out vec4 fragColor, in vec2 fragCoord )

{
    vec2 q =  fragCoord.xy / iResolution.xy;
	vec2 uv = fragCoord.xy / iResolution.xy*2.-1.;
    uv.x *= iResolution.x/iResolution.y;
    vec3 col = vec3(0.);
    
    
    for(int i=0; i<nbMeta; i++)
    {
     	meta[i].x = cos(t*hash(float(i))*2.) * hash(float(i)+.1)*2.;
     	meta[i].y = sin(t*hash(float(i))) * hash(float(i)+.2);
     	meta[i].z = abs( hash(float(i)))*5.+.01;  
    }
    
    
    float d = map(uv);
    vec3 n = normal(uv);
    
    vec2 p = uv+n.rb;
    p = mix(uv,p, clamp( pow( q.x*q.y*(1.-q.x)*(1.-q.y)*20., 2.5), 0., 1.));
    col.r = bckground( p+vec2(.01,0.)).r;
    col.g = bckground( p+vec2(0.,.01)).g;
    col.b = bckground( p+vec2(0.,.01)).b;
    col = pow( col, vec3(1./2.2));
    
    col = mix(bckground2(uv+vec2(0.,.2)).rgb, col,  clamp( pow( q.x*q.y*(1.-q.x)*(1.-q.y)*30., 2.5), 0., 1.));
    //
    
    col *= .5 + .5*pow( q.x*q.y*(1.-q.x)*(1.-q.y)*50., .5);
    
	fragColor = vec4(col,1.0);
        return fragColor; 
}

///////////////////////////////////////////////////////////////////////////////// 
void main(void) { // this will be run for every pixel of gl_FragCoord.xy
vec4 fragColor = vec4(1.0); // initialize variable fragColor as a vec4 
vec4 cc = mainImage(fragColor, gl_FragCoord.xy); // call function mainImage and assign the return vec4 to cc
gl_FragColor = vec4(cc) * gl_Color; // set the pixel to the value of vec4 cc  and..
}

// ..uses the values of any Color: or Opacity:
// clauses (and any Animate clauses applied to these properties) 
// appearing in the Sprite, Quad or other node invoking the shader 
// in the .scn file.